/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.UpdateCheckerPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.AbstractActionButton;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class UpdateCheckerWindow
extends JDialog
implements ActionListener {
    private final UpdateCheckerPresenter presenter;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private JComponent updateOpenMSXLauncherButton;
    private JComponent updateExtraDataButton;
    private JComponent downloadScreenshotsButton;
    private JButton closeButton;
    private JPanel launcherVersionPane;
    private JPanel extraDataVersionPane;
    private static final Dimension INSTALL_BUTTON_SIZE = new Dimension(100, 18);

    public UpdateCheckerWindow(UpdateCheckerPresenter presenter, Language language, boolean rightToLeft) {
        this.presenter = presenter;
        this.rightToLeft = rightToLeft;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
    }

    public void display() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("CHECK_FOR_UPDATES"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel tablePane = new JPanel();
        GridBagLayout tableLayout = new GridBagLayout();
        tablePane.setLayout(tableLayout);
        GridBagConstraints valueConstraints = new GridBagConstraints();
        valueConstraints.fill = 2;
        valueConstraints.anchor = 18;
        valueConstraints.weightx = 1.0;
        valueConstraints.gridwidth = 0;
        valueConstraints.insets = new Insets(4, 4, 4, 8);
        GridBagConstraints labelConstraints = (GridBagConstraints)valueConstraints.clone();
        labelConstraints.weightx = 0.0;
        labelConstraints.gridwidth = 1;
        this.launcherVersionPane = new JPanel();
        JLabel launcherMessage = new JLabel();
        this.launcherVersionPane.add(launcherMessage);
        if (this.presenter.isNewOpenMSXLauncherVersionDownloaded()) {
            launcherMessage.setText(this.messages.get("NEW_VERSION_DOWNLOADED_NEED_RESTART"));
        } else if (this.presenter.isNewOpenMSXLauncherVersionAvailable()) {
            launcherMessage.setText(this.messages.get("NEW_VERSION_AVAILABLE"));
            this.updateOpenMSXLauncherButton = new InstallButton(this, this.messages.get("INSTALL"));
            this.launcherVersionPane.add(this.updateOpenMSXLauncherButton);
        } else {
            launcherMessage.setText(this.messages.get("UP_TO_DATE"));
        }
        this.addPropertyToDisplay(tablePane, tableLayout, "openMSX Launcher", this.launcherVersionPane, labelConstraints, valueConstraints, true);
        this.extraDataVersionPane = new JPanel();
        JLabel extraDataMessage = new JLabel();
        this.extraDataVersionPane.add(extraDataMessage);
        if (this.presenter.isNewExtraDataVersionAvailable()) {
            extraDataMessage.setText(this.messages.get("NEW_VERSION_AVAILABLE"));
            this.updateExtraDataButton = new InstallButton(this, this.messages.get("INSTALL"));
            this.extraDataVersionPane.add(this.updateExtraDataButton);
        } else {
            extraDataMessage.setText(this.messages.get("UP_TO_DATE"));
        }
        this.addPropertyToDisplay(tablePane, tableLayout, this.messages.get("EXTRA_DATA"), this.extraDataVersionPane, labelConstraints, valueConstraints, false);
        JPanel screenshotsVersionPane = new JPanel();
        JLabel screenshotsMessage = new JLabel();
        screenshotsVersionPane.add(screenshotsMessage);
        if (!this.presenter.isScreenshotsSetInSettings()) {
            screenshotsMessage.setText(this.messages.get("UNDEFINED"));
        } else if (this.presenter.isNewScreenshotsVersionAvailable()) {
            screenshotsMessage.setText(this.messages.get("NEW_VERSION_AVAILABLE"));
            this.downloadScreenshotsButton = new InstallButton(this, this.messages.get("DOWNLOAD"));
            screenshotsVersionPane.add(this.downloadScreenshotsButton);
        } else {
            screenshotsMessage.setText(this.messages.get("UP_TO_DATE"));
        }
        this.addPropertyToDisplay(tablePane, tableLayout, this.messages.get("SCREENSHOTS"), screenshotsVersionPane, labelConstraints, valueConstraints, false);
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new FlowLayout(1, 5, 5));
        this.closeButton = new JButton(this.messages.get("CLOSE"));
        this.closeButton.addActionListener(this);
        this.closeButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.closeButton);
        if (this.rightToLeft) {
            tablePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.launcherVersionPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.extraDataVersionPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            screenshotsVersionPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.launcherVersionPane.setLayout(new FlowLayout(2, 5, 0));
            this.extraDataVersionPane.setLayout(new FlowLayout(2, 5, 0));
            screenshotsVersionPane.setLayout(new FlowLayout(2, 5, 0));
        } else {
            this.launcherVersionPane.setLayout(new FlowLayout(0, 5, 0));
            this.extraDataVersionPane.setLayout(new FlowLayout(0, 5, 0));
            screenshotsVersionPane.setLayout(new FlowLayout(0, 5, 0));
        }
        contentPane.add(tablePane);
        contentPane.add(buttonsPane);
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    private void addPropertyToDisplay(JPanel tablePane, GridBagLayout tableLayout, String attribute, JPanel value, GridBagConstraints labelConstraints, GridBagConstraints valueConstraints, boolean colonOnTheLeft) {
        JLabel attributeLabel = this.rightToLeft && colonOnTheLeft ? new JLabel(":" + attribute) : new JLabel(attribute + ":");
        tableLayout.setConstraints(attributeLabel, labelConstraints);
        tablePane.add(attributeLabel);
        if (this.rightToLeft) {
            attributeLabel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        tableLayout.setConstraints(value, valueConstraints);
        tablePane.add(value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.dispose();
        } else if (source == this.updateOpenMSXLauncherButton) {
            try {
                this.presenter.onRequestUpdateOpenMSXLauncher();
                this.showSuccessfulUpdateMessage(this.launcherVersionPane, this.messages.get("NEW_VERSION_DOWNLOADED_NEED_RESTART"));
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.rightToLeft);
            }
        } else if (source == this.updateExtraDataButton) {
            try {
                this.presenter.onRequestUpdateExtraData();
                this.showSuccessfulUpdateMessage(this.extraDataVersionPane, this.messages.get("UPDATED_SUCCESSFULLY"));
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.rightToLeft);
            }
        } else if (source == this.downloadScreenshotsButton) {
            try {
                this.presenter.onRequestOpenDownloadPage();
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.rightToLeft);
            }
        }
    }

    private void showSuccessfulUpdateMessage(JPanel panel, String message) {
        panel.removeAll();
        panel.add(new JLabel(message));
        panel.validate();
        panel.repaint();
    }

    private class InstallButton
    extends AbstractActionButton {
        private final String label;

        InstallButton(ActionListener listener, String label) {
            super(listener, new Color(40, 70, 170), new Color(50, 80, 180), new Color(30, 40, 150));
            this.label = label;
            this.setPreferredSize(INSTALL_BUTTON_SIZE);
            this.setCursor(new Cursor(12));
        }

        @Override
        protected void drawButton(Graphics g) {
            g.fillRoundRect(0, 0, this.getWidth(), this.getHeight() - 1, 10, 10);
            g.drawRoundRect(0, 0, this.getWidth(), this.getHeight() - 1, 10, 10);
            g.setColor(Color.white);
            FontMetrics fm = this.getFontMetrics(this.getFont());
            g.drawString(this.label, this.getWidth() / 2 - fm.stringWidth(this.label) / 2, this.getHeight() / 2 + fm.getMaxDescent() + 1);
        }
    }
}

